package edu.unl.consystlab.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

import edu.unl.consystlab.util.Debug;

public class ScalingImage extends Component {
    
    private Image image;
    private Image orig;
    public ScalingImage(Image image)
    {
        super();
        this.orig = this.image = image;
    }
        
    public Dimension getPreferredSize()
    {
        Dimension dim =
            new Dimension(image.getHeight(this), image.getWidth(this));
        Debug.debug("ScalingImage(): preferredSize: " +dim);
        return dim;
    }
    
    public Dimension getMaximumSize()
    {
        return getPreferredSize();
    }
    
    public Dimension getMinimumSize()
    {
        Dimension dim = new Dimension(10,10);
        Debug.debug("ScalingImage(): getMinimumSize(): " +dim);
        return dim;
    }
    
    public void setSize(Dimension d)
    {
        setSize(d.height, d.width);
    }
    
    public void setSize(int h, int w)
    {
        Debug.debug("ScalingImage(): scaling to: "+h+"x"+w);     
        image = image.getScaledInstance(w,h,Image.SCALE_FAST);
    }
    
    public void paint(Graphics g)
    {
        int h=this.getHeight();
        int w=this.getWidth();
        if(image==null || h<=0 || w<=0) return;
        if(image.getHeight(this)!=h ||
           image.getWidth(this)!=w)
        {
            image = orig.getScaledInstance(w,h,Image.SCALE_FAST);
        }
        Debug.debug("ScalingImage(): painting...");
        if(image!=null) g.drawImage(image,0,0,this);
    }
}
